# Integration Instructions: ACME

## What is a Design System?

A design system is a cohesive set of rules, values, and guidelines that ensure visual consistency across an entire codebase. It defines how colors, typography, spacing, components, and brand voice work together to create a unified user experience.

**Your goal:** Transform the target codebase to consistently reflect the ACME brand identity. Every UI component, page, and interaction should follow these specifications.

**Expected outcome:** A codebase where all visual elements — colors, fonts, spacing, components — align with the brand's design language.

## Contents

- `spec/` - Design specification split by concern:
  - `brand.md` - Read first to understand the brand personality, visual style, and voice/tone
  - `colors.md` - Use to apply consistent color values throughout the UI
  - `typography.md` - Use to set up font families, type scale, and text styles
  - `layout.md` - Use for spacing, grid, shadows, animations, and responsive behavior
  - `components.md` - Use to style buttons, cards, forms, icons, and common UI patterns
  - `logo.md` - Follow for correct logo placement, sizing, and color variants
- `design-tokens.json` - W3C design tokens format for programmatic integration
- `logos/` - Logo assets in SVG and PNG formats

## When to Use Each Spec File

| Task | File to Reference |
|------|-------------------|
| Writing marketing copy, UI text | `brand.md` (voice & tone section) |
| Setting up CSS variables, theming | `colors.md` + `typography.md` |
| Building/styling components | `components.md` + `layout.md` |
| Layout, spacing, responsive design | `layout.md` |
| Logo placement, sizing | `logo.md` |

**Tip:** For targeted AI context, only include the relevant spec file(s) in your prompt rather than all 6.

## Integration Steps

### 1. Update global styles

Merge the design tokens into your existing CSS variables or Tailwind config:

- Import brand colors from `design-tokens.json` under `color.brand`
- Update typography settings from `design-tokens.json` under `typography.fontFamily`
- Apply semantic colors for UI states (success, warning, error, info)

### 2. Move logo assets

Copy the `logos/` folder contents to your project's public assets directory.

### 3. Update component library

Review `spec/components.md` and `spec/layout.md` to update or create base components.

### 4. Update AI configuration

Add a reference to this design system in your project's AI configuration file:
`CLAUDE.md`, `.cursorrules`, `.github/copilot-instructions.md`, or `AGENTS.md`

---
Generated by Design Rails
